#I made this space invader game with <player movement>, <player shoot>, <spawn invaders>, <spawn bosses>, <boss shoot>, <display score>, and <game over> mechanics
#I made the invader and player images with Adobe Illustrator
#font is downloaded from https://www.dafont.com/bitmap.php
################################################
################################################
#####                                     ######
#####           ↑↓←→ : move               ######
#####           Space: shoot              ######
#####                                     ######
################################################
################################################

#star background
starX = []
starY = []
starSize = []


#player movement
player = []
playerX = 700
playerY = 1200
keyBool = [[UP,False],[DOWN,False],[RIGHT, False], [LEFT, False]]
speed = 10

#bullet travel
bulletX = []
bulletY = []
bulletSpeed = 15

#enemy setup
enemyImg = []
enemyX = []
enemyY = []
enemyDir = 1
enemyAllDie = False
randomEnemy = 0
enemySize = 150

#boss setup
boss = False
bossLife = 20
bossBulletX = []
bossBulletY = []


#store score points
score = 0
font = []

#gameover
gameover = False

def setup():
    size(1400,1400)
    
    #load font
    font.append(createFont('font.TTF', 50))
    #load player image
    playerImg = loadImage('player.png')
    player.append(playerImg)
    
    #load enemy images
    for i in range(5):
        enemyImg.append(loadImage('enemy'+str(randomEnemy)+ '.png'))
        
        
    #add enemy locations
    for i in range(5):
        enemyY.append(0)
    enemyX.append(300)
    enemyX.append(450)
    enemyX.append(600)
    enemyX.append(750)
    enemyX.append(900)
    
    
    #add star positions and sizes
    for i in range(100):
        starX.append(random(0,width))
        starY.append(random(0,width))
        starSize.append(random(7))
        
    
    
    
def draw():
    global randomEnemy, enemyImg, score, enemyAllDie, font, gameover
    smooth()
    background(3)

    #generate random enemies every round
    if enemyAllDie == True:
        randomEnemy = int(random(4))
        for i in range(5):
            enemyImg.append(loadImage('enemy'+str(randomEnemy)+ '.png'))
        
    
    #draw stars background
    for i in range(len(starX)):
        pushStyle()
        fill(250)
        stroke(255 )
        strokeWeight(starSize[i])
        point(starX[i], starY[i])
        popStyle()

    
    
    if gameover == False:
        #display and control player
        playerController()
        #generate enemies
        showInvader()
    else:
        pushStyle()
        textSize(100)
        textMode(CENTER)
        text("GAME OVER", width/2 - 400, height/2)
        popStyle()
    #display scores
    fill(255)
    textFont(font[0])
    text("SCORE: " + str(score), 80, 100)
    
    
def playerController():
    global bulletX, bulletY, playerX, playerY, speed
    
    #draw player image
    imageMode(CENTER)
    image(player[0], playerX, playerY, 180, 180)
    
    #use booleans to detect moving directions
    if keyBool[0][1] == True and playerY > height - 450:
        playerY = playerY - speed
    if keyBool[1][1] == True and playerY < height - 90:
        playerY = playerY + speed
    if keyBool[2][1] == True and playerX < width - 75:
        playerX = playerX + speed
    if keyBool[3][1] == True and playerX > 75:
        playerX = playerX - speed
    
    #call shoot function for player to shoot projectiles
    shoot()
    
    
def keyPressed():
    global bulletX, bulletY, playerX, playerY
    
    #press space bar to add one bullet
    if key == ' ':
        bulletX.append(playerX)
        bulletY.append(playerY - 80)
    
    #use booleans to enable player to move towards multiple directions
    for k in keyBool:
        if keyCode == k[0]:
            k[1] = True
    
        
def keyReleased():
    for k in keyBool:
        if keyCode == k[0]:
            k[1] = False

        
def shoot():
    global bulletX, bulletY, bulletSpeed
    
    #draw bullets
    for i in reversed(range(len(bulletX))):
        
        #draw bullets
        pushMatrix()
        rectMode(CENTER)
        fill(0,255,128)
        stroke(51,255,255)
        strokeWeight(1)
        bulletY[i] = bulletY[i] - bulletSpeed
        rect(bulletX[i], bulletY[i], 10, 50, 10)
        popMatrix()
        
        #if bullet out of bound, destroy bullet positions
        if bulletY[i] < -10:
            bulletX.pop(i)
            bulletY.pop(i)
    
    

def showInvader():
    global enemyImg, enemyX, enemyY, enemyDir, bulletX, bulletY, score, enemyAllDie, enemySize, boss, bossLife, bossBulletX, bossBulletY, playerX, playerY, gameover
   
                
    for i in reversed(range(len(enemyX))):
        
        #enemy spawn-phase animations
        if enemyY[i] < 300:
            enemyY[i] = enemyY[i] + 5
        else:
            enemyX[i] = enemyX[i] + (5  * enemyDir)
        
        #invader moving left and right
        if enemyX[i] < (enemySize/2) or enemyX[i] > (width - enemySize/2):
            enemyDir = enemyDir * -1
        
        #draw invader images
        image(enemyImg[i], enemyX[i], enemyY[i], enemySize, enemySize)
    
        #detect bullet and enemy collisions    
        for j in reversed(range(len(bulletY))):
            #bullet and boss collision
            if boss == True:
                if bulletY[j] < 470 and bulletY[j] > 70 and bulletX[j] > enemyX[i] - 200 and bulletX[j] < enemyX[i] + 200: 
                    bulletX.pop(j)
                    bulletY.pop(j)
                    bossLife = bossLife - 1
                    print(bossLife)
                    #destroy boss if boss life is equal to 0
                    if bossLife < 1:
                        enemyX.pop(i) 
                        enemyY.pop(i) 
                        score = score + 5 
                        boss = False
                        
            #bullet and invader collision        
            elif bulletY[j] < 370 and bulletY[j] > 270 and bulletX[j] > enemyX[i] - 35 and bulletX[j] < enemyX[i] + 35:
                bulletX.pop(j)
                bulletY.pop(j)
                enemyX.pop(i) 
                enemyY.pop(i)        
                score = score + 1

    #detect enemy are all destroyed or not
    if len(enemyX) == 0:
        enemyAllDie = True
        #spawn BOSS every 30 scores
        if score % 30 == 0:
            boss = True
            bossLife = 20
            enemySize = 500
            enemyY.append(0)
            enemyX.append(750)
        
        #if no boss spawn invaders
        else:
            boss = False
            enemySize = 150
            for i in reversed(range(len(enemyImg))):
                enemyImg.pop()
            
            for i in range(5):
                enemyY.append(0)
            enemyX.append(300)
            enemyX.append(450)
            enemyX.append(600)
            enemyX.append(750)
            enemyX.append(900)
    
    else:
        enemyAllDie = False

    
    #if boss spawned and is in position, add bullets
    if boss == True and enemyY[0] == 300:
        
        #spawn 5 bullets 
        while len(bossBulletX) < 5:
            bossBulletX.append(enemyX[0] - 200)
            bossBulletY.append(enemyY[0] + 200)
            bossBulletX.append(enemyX[0] - 100)
            bossBulletY.append(enemyY[0] + 200)
            bossBulletX.append(enemyX[0])
            bossBulletY.append(enemyY[0] + 200)
            bossBulletX.append(enemyX[0] + 100)
            bossBulletY.append(enemyY[0] + 200)
            bossBulletX.append(enemyX[0] + 200)
            bossBulletY.append(enemyY[0] + 200)
        
        #draw boss bullets
        for x in reversed(range(len(bossBulletX))):
            #bullet movements
            bossBulletX[x] = bossBulletX[x] + random(-5, 5)
            bossBulletY[x] = bossBulletY[x] + random(-5,5)
            bossBulletY[x] = bossBulletY[x] + random(10,12)
            
            #draw bullets
            pushStyle()
            fill(250,0,0)
            stroke(200,0,0)
            ellipse(bossBulletX[x], bossBulletY[x], 20, 20)
            ellipse(bossBulletX[x], bossBulletY[x], 20, 20)
            popStyle() 
            
            #if bullet out of bound, destroy bullet
            if bossBulletY[x] > height:
                bossBulletX.pop(x)
                bossBulletY.pop(x)
            
            #if boss bullet hit player, game is over
            elif bossBulletX[x] > playerX - 70 and bossBulletX[x] < playerX + 70 and bossBulletY[x] > playerY - 70 and bossBulletY[x] < playerY + 70:
                bossBulletX.pop(x)
                bossBulletY.pop(x)
                
                gameover = True
    
    #if boss is dead, clear boss bullet positions
    elif boss == False:
        for x in reversed(range(len(bossBulletX))):
            bossBulletX.pop()
            bossBulletY.pop()
    
    print(bossBulletX, bossBulletY)
    print(gameover)
    
